DROP PROCEDURE [hips].[ClinicalDocumentVersionInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date: 11 Oct 2012
-- Description:   Inserts a new record into the Patient Master Table on the hips first
--					using the hips.ClinicalDocumentVersionInsert then into the hips table
-- Modified:
-- 06/12/2012 - sbiber - Removed removal information (moved to ClinicalDocument table)
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentVersionInsert] 
(
	--hips fields
	@ClinicalDocumentId INT,
	@SourceSystemDocumentId varchar(128),
	@UploadedDate DATETIME = null,
	@SupersededDate datetime = null,
	@Package varbinary(MAX),
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode INT
		,@ClinicalDocumentVersionId INT
		,@CurrentDate DATETIME

    SET @intErrorCode = 0
	SET @CurrentDate = GETDATE()


    
		INSERT
		INTO [hips].[ClinicalDocumentVersion]
         ( 
          [ClinicalDocumentId]
         , [SourceSystemDocumentId]
         , [UploadedDate]
         , [SupersededDate]
         , [Package]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         )
		VALUES
         ( 
         @ClinicalDocumentId
         , @SourceSystemDocumentId
         , @UploadedDate
         , @SupersededDate
         , @Package
         , @CurrentDate
         , @UserModified
         , @CurrentDate
         , @UserModified
         )

    
    SELECT @intErrorCode = @@ERROR, @ClinicalDocumentVersionId = SCOPE_IdENTITY()
	
    IF @intErrorCode = 0
    BEGIN
        SELECT [ClinicalDocumentVersionId]
		 , [SourceSystemDocumentId]
         , [UploadedDate]
         , [SupersededDate]
         , [Package]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         FROM [hips].[ClinicalDocumentVersion]
         WHERE [ClinicalDocumentVersionId] = @ClinicalDocumentVersionId
   end
   RETURN(@intErrorCode)
END
GO

